
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1200.C - Message 1200 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1200 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1200.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:54   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:44:12   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:30   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:42:50   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:00   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1200 message from the ZMsgBuf.
//
void Dec1200(tMSGBUF *ZMsgBuf, tMSG1200 *Msg)
{  
   GetBit(&InitValidData.ForceTime         , ZMsgBuf, 7,0);  // 1=valid
   GetBit(&InitValidData.GPSTimeValid      , ZMsgBuf, 7,1);  // 1=valid
   GetBit(&InitValidData.UTCTimeValid      , ZMsgBuf, 7,2);  // 1=valid
   GetBit(&InitValidData.LatLonValid       , ZMsgBuf, 7,3);  // 1=valid
   GetBit(&InitValidData.AltitudeValid     , ZMsgBuf, 7,4);  // 1=valid
   GetBit(&InitValidData.SpeedCourseValid  , ZMsgBuf, 7,5);  // 1=valid
   GetBit(&InitValidData.MagneticCourse    , ZMsgBuf, 7,6);  // 1=magnetic
   GetBit(&InitValidData.ClimbRateValid    , ZMsgBuf, 7,7);  // 1=valid
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1200 message in the ZMsgBuf. 
//
void Bld1200(tMSGBUF *ZMsgBuf, tMSG1200 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                  , ZMsgBuf, 1);    // message preamble
   PutShort  (1200                    , ZMsgBuf, 2);    // message number
   PutShort  (21                      , ZMsgBuf, 3);    // message length
   PutShort  (ANREQ                   , ZMsgBuf, 4);    // message ack/nack request
   
   // poke bits into the packed words in the buffer
   PutBit(InitValidData.GPSTimeValid       , ZMsgBuf, 7,1);  // 1=valid
   PutBit(InitValidData.UTCTimeValid       , ZMsgBuf, 7,2);  // 1=valid
   PutBit(InitValidData.LatLonValid        , ZMsgBuf, 7,3);  // 1=valid
   PutBit(InitValidData.AltitudeValid      , ZMsgBuf, 7,4);  // 1=valid
   PutBit(InitValidData.SpeedCourseValid   , ZMsgBuf, 7,5);  // 1=valid
   PutBit(InitValidData.MagneticCourse     , ZMsgBuf, 7,6);  // 1=magnetic
   PutBit(InitValidData.ClimbRateValid     , ZMsgBuf, 7,7);  // 1=valid     
}
